#! /bin/bash

gpu=7
cpu="64-72"
pool_size=${#gpu_list[@]}
host_name=`uname -n`

data_name=cora

#########################
## config tuining
# core config
model_name="SAGE"
GNN_target_path=../result/${data_name}/${model_name}/seed_0
## SDMP config
SDMP_config_root=../config/${data_name}/SDMP
# declare -a SDMP_config_name=("${data_name}_SDMP_base_partial_train.yml")
declare -a SDMP_config_name=("${data_name}_SDMP_base.yml")
SDMP_result_path=../result/debug/${data_name}_${model_name}_SDMP
## test config
declare -a TEST_config_name=("${data_name}_test_SDMP0_partial.yml")
TEST_config_root=../config/${data_name}
TEST_result_path=../result/debug/${data_name}_${model_name}_MLP_TEST

taskset -c ${cpu} python ../main_gen_SDMP.py --data ../dataset --config ${SDMP_config_root}/${SDMP_config_name[$idx]} --device "cuda:${gpu}" --result "${SDMP_result_path}" --gnn $GNN_target_path 
taskset -c ${cpu} python ../main_test_SDMP.py --data ../dataset --dict ${SDMP_result_path} --config ${TEST_config_root}/${TEST_config_name[$out_idx]} --device "cuda:${gpu}" --result "${TEST_result_path}" --gnn $GNN_target_path